/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.client.gui;

import com.agricraft.agricraft.api.genetic.AgriGenePair;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import com.agricraft.agricraft.common.inventory.container.SeedAnalyzerMenu;
import com.agricraft.agricraft.common.util.LangUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5250;

public class SeedAnalyzerScreen
extends class_465<SeedAnalyzerMenu> {
    private final class_2960 GUI = new class_2960("agricraft", "textures/gui/seed_analyzer.png");
    private final class_2561 TEXT_SEPARATOR = class_2561.method_43470((String)"-");
    private int geneIndex;

    public SeedAnalyzerScreen(SeedAnalyzerMenu screenContainer, class_1661 inv, class_2561 title) {
        super((class_1703)screenContainer, inv, title);
        this.field_2792 = 186;
        this.field_2779 = 186;
        this.field_25270 = this.field_2779 - 94;
        this.geneIndex = 0;
    }

    private static boolean hoverUpButton(int startX, int startY, int mouseX, int mouseY) {
        return startX + 67 <= mouseX && mouseX <= startX + 67 + 9 && startY + 26 <= mouseY && mouseY <= startY + 26 + 9;
    }

    private static boolean hoverDownButton(int startX, int startY, int mouseX, int mouseY) {
        return startX + 67 <= mouseX && mouseX <= startX + 67 + 9 && startY + 90 <= mouseY && mouseY <= startY + 90 + 9;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.GUI);
        int relX = (this.field_22789 - this.field_2792) / 2;
        int relY = (this.field_22790 - this.field_2779) / 2;
        guiGraphics.method_25302(this.GUI, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        guiGraphics.method_25302(this.GUI, this.field_2776 + 25, this.field_2800 + 70, 186, 73, 18, 18);
        guiGraphics.method_25302(this.GUI, this.field_2776 + 13, this.field_2800 + 25, 0, 186, 56, 56);
        Optional<AgriGenome> optionalGenome = ((SeedAnalyzerMenu)this.field_2797).getGenomeToRender();
        if (optionalGenome.isEmpty()) {
            return;
        }
        AgriGenome genome = optionalGenome.get();
        if (genome.getStatGenes().size() > 6) {
            int upXOffset = SeedAnalyzerScreen.hoverUpButton(this.field_2776, this.field_2800, mouseX, mouseY) ? 195 : 186;
            guiGraphics.method_25302(this.GUI, this.field_2776 + 67, this.field_2800 + 26, upXOffset, 91, 9, 9);
            int downXOffset = SeedAnalyzerScreen.hoverDownButton(this.field_2776, this.field_2800, mouseX, mouseY) ? 195 : 186;
            guiGraphics.method_25302(this.GUI, this.field_2776 + 67, this.field_2800 + 90, downXOffset, 100, 9, 9);
        }
        AgriGenePair<String> species = genome.getSpeciesGene();
        class_2561 speciesDomText = LangUtils.plantName(species.getDominant().trait());
        class_2561 speciesRecText = LangUtils.plantName(species.getRecessive().trait());
        int domw = this.field_22793.method_1727(speciesDomText.getString());
        int middle = this.field_2776 + this.field_2792 / 2;
        int sepLength = this.field_22793.method_1727(this.TEXT_SEPARATOR.getString());
        guiGraphics.method_51439(this.field_22793, this.TEXT_SEPARATOR, (int)((float)middle - (float)sepLength / 2.0f), this.field_2800 + 16, 0, false);
        guiGraphics.method_51439(this.field_22793, speciesDomText, (int)((float)(middle - domw) - (float)sepLength / 2.0f - 1.0f), this.field_2800 + 16, 0, false);
        guiGraphics.method_51439(this.field_22793, speciesRecText, (int)((float)middle + (float)sepLength / 2.0f + 1.0f), this.field_2800 + 16, 0, false);
        int DNA_X = this.field_2776 + 90;
        int yy = this.field_2800 + 26;
        int[] lineAmount = new int[]{3, 2, 2, 3, 2, 3};
        int[] lineStart = new int[]{0, 15, 25, 35, 50, 60};
        List<AgriGenePair<Integer>> statGenes = genome.getStatGenes().stream().toList();
        int i = this.geneIndex;
        int lineIndex = 0;
        while (i < this.geneIndex + 6) {
            AgriGenePair<Integer> pair = statGenes.get(i);
            for (int k = 0; k < lineAmount[lineIndex]; ++k) {
                guiGraphics.method_25292(DNA_X, DNA_X + 9, this.field_2800 + 26 + lineStart[lineIndex] + k * 5, pair.getGene().getDominantColor());
                guiGraphics.method_25292(DNA_X + 9, DNA_X + 9 + 8, this.field_2800 + 26 + lineStart[lineIndex] + k * 5, pair.getGene().getRecessiveColor());
            }
            class_2561 geneText = (class_2561)AgriStatRegistry.getInstance().get(pair.getGene().getId()).map(LangUtils::statName).orElse(class_2561.method_43473());
            class_5250 domText = class_2561.method_43470((String)("" + pair.getDominant().trait()));
            class_5250 recText = class_2561.method_43470((String)("" + pair.getRecessive().trait()));
            int w = this.field_22793.method_1727(domText.getString());
            guiGraphics.method_51439(this.field_22793, geneText, DNA_X + 36, yy, 0, false);
            guiGraphics.method_51439(this.field_22793, (class_2561)domText, DNA_X - w - 1, yy, 0, false);
            guiGraphics.method_51439(this.field_22793, (class_2561)recText, DNA_X + 21, yy, 0, false);
            Objects.requireNonNull(this.field_22793);
            yy += 9 + 4;
            ++i;
            ++lineIndex;
        }
        guiGraphics.method_25302(this.GUI, DNA_X, this.field_2800 + 26, 186, 0, 19, 73);
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51439(this.field_22793, this.field_22785, this.field_25267 + 5, this.field_25268, 0x404040, false);
        guiGraphics.method_51439(this.field_22793, this.field_29347, this.field_25269 + 5, this.field_25270, 0x404040, false);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        Optional<AgriGenome> opt = ((SeedAnalyzerMenu)this.field_2797).getGenomeToRender();
        if (opt.isEmpty()) {
            return super.method_25402(mouseX, mouseY, button);
        }
        int maxIndex = opt.get().getStatGenes().size() - 1;
        if (opt.map(agriGenome -> agriGenome.getStatGenes().size()).orElse(0) > 6) {
            int startX = (this.field_22789 - this.field_2792) / 2;
            int startY = (this.field_22790 - this.field_2779) / 2;
            if (SeedAnalyzerScreen.hoverUpButton(startX, startY, (int)mouseX, (int)mouseY) && this.geneIndex > 0) {
                --this.geneIndex;
            }
            if (SeedAnalyzerScreen.hoverDownButton(startX, startY, (int)mouseX, (int)mouseY) && maxIndex - this.geneIndex > 6) {
                ++this.geneIndex;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        Optional<AgriGenome> opt = ((SeedAnalyzerMenu)this.field_2797).getGenomeToRender();
        if (opt.isEmpty()) {
            return super.method_25401(mouseX, mouseY, delta);
        }
        int maxIndex = opt.get().getStatGenes().size() - 1;
        if (maxIndex > 6) {
            if (delta < 0.0) {
                if (maxIndex - this.geneIndex > 6) {
                    ++this.geneIndex;
                }
            } else if (delta > 0.0 && this.geneIndex > 0) {
                --this.geneIndex;
            }
        }
        return super.method_25401(mouseX, mouseY, delta);
    }
}

